# -*- coding: utf-8 -*-
"""
Created on Tue Oct 27 18:46:47 2015

@author: gareth
"""
import numpy as np
import types_check

def CompareTypes(AParameter1,AParameter2,AIgnoreNumpyDifference=True):
    if AIgnoreNumpyDifference:
        if IsListOrNumpyArray(AParameter1) and IsListOrNumpyArray(AParameter2):
            return True
        elif IsBoolean(AParameter1) and IsBoolean(AParameter2):
            return True
        elif IsInteger(AParameter1) and IsInteger(AParameter2):
            return True
        elif IsFloat(AParameter1) and IsFloat(AParameter2):
            return True

    return type(AParameter1)==type(AParameter2)    
        

def InclusiveRange(AMin,AMax,AStep=1):
#==============================================================================
#     result = np.arange(AMin,AMax + tolerance,AStep)
#     result = np.arange(AMin,AMax,AStep)
#     tolerance = max(abs(AMax),abs(AMin) * 0.00001*AStep)
#==============================================================================
    if type(AStep) is int:
        result = np.arange(AMin,AMax+AStep,AStep)
        return result
    else:
        return np.arange(AMin,AMax+0.00001*AStep,AStep)

def IsBoolean(AParameter):
    if IsListOrNumpyArray(AParameter):
        return False    
    if types_check.is_float(AParameter):
        return False
    if AParameter == True:
        return True
    if AParameter == False:
        return True
    # not a boolean    
    return False
        
def IsFloat(AParameter):
    if types_check.is_list(AParameter):
        return False    
    return types_check.is_float(AParameter)

def IsInteger(AParameter):
    if types_check.is_list(AParameter):
        return False    
    return types_check.is_integer(AParameter)

def IsListOrNumpyArray(AParameter):
    if types_check.is_list(AParameter):
        return True
    if isinstance(AParameter, np.ndarray):
        return True
    return False
    
